#!/usr/bin/env python
#version 20170208
import os,time,platform
import socket
import smtplib


#Get the local Server IP
def getlocalip():
	
	s = socket.socket(socket.AF_INET,socket.SOCK_STREAM)
	port = socket.getservbyname("http","tcp")
	s.connect(("www.baidu.com",port))
	ip = s.getsockname()
	s.close()	
	return ip


#Get RAID STATE
def getraidstate(path):
	
	cmd1 = path + '/MegaCli64 -ldinfo -lall -aall -Nolog'
	rdfile = os.popen(cmd1)
	raidstate=''

	for line in rdfile:

		if "State" in line:
			
			tmp = line.split(":")
			
			if tmp[1].strip() != 'Optimal':
				
				return tmp[1].strip()


#Get local disk status
def getdiskstat(path):
	
	cmd1 = path + '/MegaCli64 -PDList -aAll -Nolog'
	rdfile = os.popen(cmd1)
	head = "Slot Number"
	diskstat = {}
	diskerr = 0
	diskcount = 0
	
	for line in rdfile:
	
		if head in line:
			
			disknum = line.split(":")
			diskname='disk'+str(disknum[1].strip())
			diskcount += 1
			
		if "Media Error Count" in line:
			
			ERR = line.split(":")
			key = diskname+"."+ERR[0]
	
			if ERR[1].strip() != "0":
				
				diskerr += 1
				diskstat[key] = ERR[1].strip()
				
		if "Other Error Count" in line:
			
			ERR = line.split(":")
			key = diskname+"."+ERR[0]

			if ERR[1].strip() != "0":
				
				diskerr += 1
				diskstat[key] = ERR[1].strip()
				
		if "Predictive Failure Count" in line:
			
			ERR = line.split(":")
			key = diskname+"."+ERR[0]
			
			if ERR[1].strip() != "0":
				
				diskerr += 1
				diskstat[key] = ERR[1].strip()
			
		if "Firmware state" in line:
			
			stat = line.strip().split(":")
			key = diskname+"."+stat[0]
	
			if " Online, Spun Up" != stat[1] and " Online, Spun down" != stat[1] and " Hotspare, Spun down" != stat[1] and " Hotspare, Spun Up" != stat[1] and " Hotspare, Transition" != stat[1]:
				
				diskerr += 1
				diskstat[key] = stat[1]
				

	#Raid disk numbers is 0 				
	if diskcount == 0:
		
		diskerr += 1
		diskstat['RaidCardError'] = "not find disk!"
		
	return diskerr,diskstat


def SendMail(from_mail,to_mail,smtp_server,user,pwd,msg):
	
	smtp = smtplib.SMTP()
	smtp.connect(smtp_server)
	smtp.login(user,pwd)
	smtp.sendmail(from_mail,to_mail,msg)
	smtp.quit()
	
#count the number of alarm
def Alarm(Max,diskstat,alarmFile):
	
	#init alarmFile
	#Get alarm file last modify time
	if os.path.exists(alarmFile):
		
		Ala_mod_time = time.strftime("%Y-%m-%d",time.localtime(os.path.getmtime(alarmFile)))

		#Get systime
		SysTime = time.strftime("%Y-%m-%d",time.localtime(time.time()))

		if(Ala_mod_time != SysTime):

			print "initing " + alarmFile
			os.remove(alarmFile)

	#no raidcard
	if diskstat.has_key('RaidCardError'):
		
		return 1	

	#create alarm file
	if not os.path.exists(alarmFile):
		
		rdfile = open(alarmFile,'w')
		rdfile.write('1')
		rdfile.close()
		return 1
	
	else:

		
		
		
		rdfile = open(alarmFile).read()
		if not len(rdfile):
			
			#alarmFile is empty
			rdfile = open(alarmFile,'w')
			rdfile.write('1')
			rdfile.close()
			return 1
		
		else:
			
			rdfile = open(alarmFile,'r')
			#print 'not empty'
			for line in rdfile:

				count=int(line.strip())
				
			rdfile.close()
				

		if count :
			
			if count < Max:
				
				count += 1
				rdfile = open(alarmFile,'w')
				rdfile.write(str(count))
				rdfile.close()
				return 1
			
			else:
				
				return 0
		else:

			return 1

############################################################
if __name__ == '__main__':

	#Configure
	#os type
	os_type = platform.system()

	
	if os_type == 'Windows':
		#WINDOWS SERVER CONFIGURE
		#Record the number of alarms
		alarmFile='D:/LOG/Windows_MegaCLI/diskalarm.tmp'
		
		#The largest number of the mail
		MaxMail = 3

		#MegarCli Path
		Mega_Path = 'D:/LOG/Windows_MegaCLI'

	elif os_type == 'Linux':
		
		#LINUX SERVER CONFIGURE

		#Record the number of alarms
		alarmFile='/tmp/diskalarm.tmp'
		
		#The largest number of the mail
		MaxMail = 3

		#MegarCli Path
		Mega_Path = '/opt/MegaRAID/MegaCli'
		
	
		

	#server public ip
	ip = getlocalip()
	
	err,stat = getdiskstat(Mega_Path)
	raidstate = getraidstate(Mega_Path)

	if err != 0 or raidstate != None:
		
		if Alarm(MaxMail,stat,alarmFile):
			
			print "send mail"
			errmsg = "ERROR Count: " + str(err) + "\n"

			
			for i in stat:
				
				errmsg = errmsg + i + ": " + stat[i] + '\n'
				

			if err == 0 and raidstate != None:
				
				#RAID STATE ERROR
				msg = '''From: smonitor@sub.wsztest.com\nto:yunwei.list@cndns.com\nSubject:Disk Error ''' + str(ip[0]) + '''\nRAID STATE :'''+ raidstate

			if err !=0 and raidstate == None:
				
				#disk error
				msg = '''From: smonitor@sub.wsztest.com\nto:yunwei.list@cndns.com\nSubject:Disk Error ''' + str(ip[0]) + '''\nDiskstat msg: \n''' + errmsg

			if err !=0 and raidstate != None:
				
				#disk and raid error
				msg = '''From: smonitor@sub.wsztest.com\nto:yunwei.list@cndns.com\nSubject:Disk Error ''' + str(ip[0]) + '''\nRAID STATE :'''+ raidstate +'''\nDiskstat msg: \n''' + errmsg

							
			SendMail("smonitor@sub.wsztest.com","yunwei.list@cndns.com","smtp.ezcdn.cn","smonitor@sub.wsztest.com","S0uF9qX2YU",msg)

		else:
			
			print 'out of alarm number'


	else:

		print 'Raid disk ok!'
		
		if os.path.exists(alarmFile):
			
			os.remove(alarmFile)
			
		else:
			
			print alarmFile + ' not exist !'
			
		


