#!/bin/bash

#Set MegaCli path and parameter
CLI="/opt/MegaRAID/MegaCli/MegaCli64"
START="-pdlocate -start -physdrv "
STOP="-pdlocate -stop -physdrv"

if [ ! -f $CLI ];then
	echo "$CLI can not found"
	exit 1
fi	

#Get Enclosure Device ID
Did=`$CLI -EncInfo -a0 -nolog|grep "Device ID"|awk -F":" '{print $2}'|sed -e 's/\(^ *\)//' -e 's/\( $\)//'`

#Get Slot number
Snum=`$CLI -EncInfo -a0 -nolog|grep "Number of Slots"|awk -F":" '{print $2}'|sed -e 's/\(^ *\)//' -e 's/\( $\)//'`

#Get Drives number
Dnum=`$CLI -EncInfo -a0 -nolog|grep "Number of Physical Drives"|awk -F":" '{print $2}'|sed -e 's/\(^ *\)//' -e 's/\( $\)//'`


# Use disk activity for locate:Enabled
$CLI -AdpSetProp UseDiskActivityforLocate -1 -a0


if [ $# == 0 ];then
   echo "Number of Slot is $Snum"
   echo "Number of Physical Drives is $Dnum"
	#check the number of disk
	if [ "$Snum" == "$Dnum" ];then
        	echo "Number of disk is OK"
	else
        	echo "Lost Disk!"

	fi

   # Slot number star from 0
   let Snum=$Snum-1

   for i in $(seq 0 $Snum)
   do
   	rs=`$CLI $START [$Did:$i] -a0 -nolog|grep successfully`
        if [ ! -z "$rs" ];then
   		echo -e "slot $i is flashing"
   		sleep 3
	
   		rs=`$CLI $STOP [$Did:$i] -a0 -nolog|grep successfully`
		if [ ! -z "$rs" ];then
   			echo -e "slot $i stop flashing"
        		sleep 3
		else
			echo "***slot $i stop failed***"
		fi
	else
		echo "***slot $i start failed***"
	fi
   done	


else
	if [ $# == 2 ];then
		if [ $1 == 'start' ];then
			rs=`$CLI $START [$Did:$2] -a0 -nolog|grep successfully`
			if [ ! -z "$rs" ];then
				echo "slot $2 flashing"
			else
				echo "***slot $2 start failed***"
			fi
		elif [ $1 == 'stop' ];then
			rs=`$CLI $STOP [$Did:$2] -a0 -nolog|grep successfully`
			if [ ! -z "$rs" ];then
				echo "slot $2 stoped"
			else
				echo "***slot $2 stoped failed***"
			fi
		fi	
	fi 
fi
