#!/usr/bin/perl
use Mail::Sender;

#get local ip
if ( -d '/proc/sys/net/ipv4/conf/br0'){
	$ip = readpipe("/sbin/ifconfig br0 | grep 'inet addr' |cut -d ':' -f2|cut -d ' ' -f1");
}elsif ( -d '/proc/sys/net/ipv4/conf/em1' ){
	$ip = readpipe("/sbin/ifconfig em1 | grep 'inet addr' |cut -d ':' -f2|cut -d ' ' -f1");
}else{
	$ip = readpipe("/sbin/ifconfig eth0 | grep 'inet addr' |cut -d ':' -f2|cut -d ' ' -f1");
}
#print "$ip\n";

#check Log directory#
if ( !-d "/var/log/checkmountnfs"){
   system('mkdir -p /var/log/checkmountnfs')
   }

#print speed
my $speed = readpipe("/sbin/ethtool `less /etc/network/interfaces | grep -A 4 'auto br1'|grep 'bridge_ports'|awk '{print \$2}'`| grep -o -P '\\d{1,}Mb/s'");
chomp($speed);
if ($speed ne '1000Mb/s') {
	&warn_mail("Chengyun-Interface Speed Wrong","$ip");
}


sub max {
        my $currentMinCnt = shift @_;
        foreach ( @_ )
                { if ($_ > $currentMinCnt )
                {
                        $currentMinCnt = $_;
                }
        }
        return $currentMinCnt;
}


my $status = getfilestatus();
sub getfilestatus {
        my $filename='/vm/nfs/template.xml';
        if(-e $filename)
        {
                return "file exist\n";
        }
        else
        {
                #return "file no exist\n"
				&warn_mail("Chengyun-Nfs-Warnning","$ip");
        }
}
#print $status;

my $YingPanWD = readpipe("hddtemp /dev/sda|awk -F ':' '{print \$3}'|grep -o -P '\\d\\d'");
if($YingPanWD gt 100)
{
#	&warn_mail("YingPanWenDu gt 100 IS: $YingPanWD","$ip");
}

my @YingPanWDAll = readpipe("/opt/MegaRAID/MegaCli/MegaCli64  -pdlist -aall -nolog|grep 'Drive Temperature'|awk -F ':' '{print \$2}'|awk -F 'C' '{print \$1}'");
my $maxYingPan = &max(@YingPanWDAll);
if ($maxYingPan gt 100)
{
#	&warn_mail("ZhenLieYingPanWenDu gt 100 IS: $maxYingPan","$ip");
}

my @CpuWD = readpipe("sensors |grep 'Physical id'|awk -F '+' '{print \$2}'|awk -F '.' '{print \$1}'");
my $maxCpu = &max(@CpuWD);
if ($maxCpu gt 100)
{
#        &warn_mail("CpuWinDu gt 100 IS: $maxCpu","$ip");
}



my $vmsize = readpipe("df -P | grep -P \'/vm\$\'|awk -F '[ %]*' '{print \$5}'");
if ($vmsize gt 96)
{
        &warn_mail("vmsize gt 96 IS: $vmsize","$ip");
}

sub warn_mail{
	my @para = @_;
	my $subject = $para[0];
	my $msg = $para[1];
	my $pass='S0uF9qX2YU';
	my $sender= new Mail::Sender{
	smtp=> 'mail.ezcdn.cn',
	from=>'smonitor@sub.wsztest.com',
	auth=>'LOGIN',
	authid=>'smonitor@sub.wsztest.com',
	authpwd=> $pass,
	debug=>'/var/log/checkmountnfs/perllog'
	};
	$sender->MailMsg({
	to=>'yunwei.list@cndns.com',
	subject=>"$subject",
	msg=>"$msg",
	debug=>'/var/log/checkmountnfs/perllog'
	}) or die "failed";
	$sender->Close();
}
