#!/bin/bash
# 20181030
RULE_HOME="/vm/Configuration_file_backup"
NWFILTER_HOME='/etc/libvirt/nwfilter'

if [ -d $RULE_HOME ];then
	RULE_PATH="$RULE_HOME/nwfilter"
	echo "Creat dirctor $RULE_PATH"
	mkdir $RULE_PATH
else
	echo "$RULE_HOME NOT FOUND"
	exit 0
fi

ls /vm/vm/ |grep -e '^S[0-9]\{6\}$' | while read line;do
	echo "Copy $line rule XML"
	RULE="$NWFILTER_HOME/${line}.xml"
	if [ -f "$RULE" ];then
		echo "$RULE is copying"
		\cp -f $RULE $RULE_PATH
		GroupRuleName=`cat $RULE |grep -a '<filterref filter='|awk -F"'" '{print $2}'`
	        GroupRuleNamePath="$NWFILTER_HOME/${GroupRuleName}.xml"
        	if [ -f $GroupRuleNamePath ];then
                	echo -e "${line}'s grouprule $GroupRuleNamePath is copying \n"
			\cp -f $GroupRuleNamePath $RULE_PATH
        	else
                	echo -e "$GroupRuleNamePath not found \n" 
	        fi
	else
		echo "$RULE not found"
		echo " "
	fi
done
echo "rule XML file in $RULE_PATH"

\cp -r /var/lib/libvirt/qemu/snapshot /vm/Configuration_file_backup
