/* recent-manager-provider.c generated by valac 0.14.2, the Vala compiler
 * generated from recent-manager-provider.vala, do not modify */

/*
 * Zeitgeist
 *
 * Copyright (C) 2010 Michal Hruby <michal.mhr@gmail.com>
 * Copyright (C) 2012 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Michal Hruby <michal.mhr@gmail.com>
 * Authored by Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <zeitgeist.h>
#include <gio/gio.h>


#define TYPE_DATA_PROVIDER (data_provider_get_type ())
#define DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_PROVIDER, DataProvider))
#define DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_PROVIDER, DataProviderClass))
#define IS_DATA_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_PROVIDER))
#define IS_DATA_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_PROVIDER))
#define DATA_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_PROVIDER, DataProviderClass))

typedef struct _DataProvider DataProvider;
typedef struct _DataProviderClass DataProviderClass;
typedef struct _DataProviderPrivate DataProviderPrivate;

#define TYPE_DATA_HUB (data_hub_get_type ())
#define DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_HUB, DataHub))
#define DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_HUB, DataHubClass))
#define IS_DATA_HUB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_HUB))
#define IS_DATA_HUB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_HUB))
#define DATA_HUB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_HUB, DataHubClass))

typedef struct _DataHub DataHub;
typedef struct _DataHubClass DataHubClass;

#define TYPE_RECENT_MANAGER_GTK (recent_manager_gtk_get_type ())
#define RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtk))
#define RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))
#define IS_RECENT_MANAGER_GTK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_MANAGER_GTK))
#define IS_RECENT_MANAGER_GTK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_MANAGER_GTK))
#define RECENT_MANAGER_GTK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkClass))

typedef struct _RecentManagerGtk RecentManagerGtk;
typedef struct _RecentManagerGtkClass RecentManagerGtkClass;
typedef struct _RecentManagerGtkPrivate RecentManagerGtkPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define __g_list_free__gtk_recent_info_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_recent_info_unref0_ (var), NULL)))

struct _DataProvider {
	GObject parent_instance;
	DataProviderPrivate * priv;
};

struct _DataProviderClass {
	GObjectClass parent_class;
	void (*start) (DataProvider* self);
	void (*stop) (DataProvider* self);
	const gchar* (*get_unique_id) (DataProvider* self);
	void (*set_unique_id) (DataProvider* self, const gchar* value);
	const gchar* (*get_name) (DataProvider* self);
	void (*set_name) (DataProvider* self, const gchar* value);
	const gchar* (*get_description) (DataProvider* self);
	void (*set_description) (DataProvider* self, const gchar* value);
	DataHub* (*get_datahub) (DataProvider* self);
	void (*set_datahub) (DataProvider* self, DataHub* value);
	gboolean (*get_enabled) (DataProvider* self);
	void (*set_enabled) (DataProvider* self, gboolean value);
	gboolean (*get_register) (DataProvider* self);
	void (*set_register) (DataProvider* self, gboolean value);
};

struct _RecentManagerGtk {
	DataProvider parent_instance;
	RecentManagerGtkPrivate * priv;
};

struct _RecentManagerGtkClass {
	DataProviderClass parent_class;
};

struct _RecentManagerGtkPrivate {
	gchar* _unique_id;
	gchar* _name;
	gchar* _description;
	DataHub* _datahub;
	gboolean _enabled;
	gboolean _register;
	GtkRecentManager* recent_manager;
	guint idle_id;
};


static gpointer recent_manager_gtk_parent_class = NULL;

GType data_provider_get_type (void) G_GNUC_CONST;
GType data_hub_get_type (void) G_GNUC_CONST;
GType recent_manager_gtk_get_type (void) G_GNUC_CONST;
#define RECENT_MANAGER_GTK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_RECENT_MANAGER_GTK, RecentManagerGtkPrivate))
enum  {
	RECENT_MANAGER_GTK_DUMMY_PROPERTY,
	RECENT_MANAGER_GTK_UNIQUE_ID,
	RECENT_MANAGER_GTK_NAME,
	RECENT_MANAGER_GTK_DESCRIPTION,
	RECENT_MANAGER_GTK_DATAHUB,
	RECENT_MANAGER_GTK_ENABLED,
	RECENT_MANAGER_GTK_REGISTER
};
RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub);
RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub);
static void recent_manager_gtk_real_start (DataProvider* base);
static void recent_manager_gtk_items_changed (RecentManagerGtk* self);
static void _recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender, gpointer self);
GPtrArray* recent_manager_gtk_get_items (RecentManagerGtk* self);
static void recent_manager_gtk_real_stop (DataProvider* base);
static gboolean ___lambda0_ (RecentManagerGtk* self);
static gboolean ____lambda0__gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
DataHub* data_provider_get_datahub (DataProvider* self);
gchar** data_hub_get_data_source_actors (DataHub* self, gboolean only_enabled, int* result_length1);
gchar* utils_get_ooo_desktop_file_for_mimetype (const gchar* mimetype);
gchar* utils_find_desktop_file_for_app (const gchar* app_name, const gchar* mimetype);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
gint64 data_provider_get_last_timestamp (DataProvider* self);
static void _gtk_recent_info_unref0_ (gpointer var);
static void _g_list_free__gtk_recent_info_unref0_ (GList* self);
void data_provider_set_last_timestamp (DataProvider* self, gint64 value);
static GObject * recent_manager_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void recent_manager_gtk_finalize (GObject* obj);
const gchar* data_provider_get_unique_id (DataProvider* self);
const gchar* data_provider_get_name (DataProvider* self);
const gchar* data_provider_get_description (DataProvider* self);
gboolean data_provider_get_enabled (DataProvider* self);
gboolean data_provider_get_register (DataProvider* self);
static void _vala_recent_manager_gtk_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void data_provider_set_unique_id (DataProvider* self, const gchar* value);
void data_provider_set_name (DataProvider* self, const gchar* value);
void data_provider_set_description (DataProvider* self, const gchar* value);
void data_provider_set_datahub (DataProvider* self, DataHub* value);
void data_provider_set_enabled (DataProvider* self, gboolean value);
void data_provider_set_register (DataProvider* self, gboolean value);
static void _vala_recent_manager_gtk_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


RecentManagerGtk* recent_manager_gtk_construct (GType object_type, DataHub* datahub) {
	RecentManagerGtk * self = NULL;
	DataHub* _tmp0_;
	g_return_val_if_fail (datahub != NULL, NULL);
	_tmp0_ = datahub;
	self = (RecentManagerGtk*) g_object_new (object_type, "unique-id", "com.zeitgeist-project,datahub,recent", "name", "Recently Used Documents", "description", "Logs events from GtkRecentlyUsed", "datahub", _tmp0_, NULL);
	return self;
}


RecentManagerGtk* recent_manager_gtk_new (DataHub* datahub) {
	return recent_manager_gtk_construct (TYPE_RECENT_MANAGER_GTK, datahub);
}


static void _recent_manager_gtk_items_changed_gtk_recent_manager_changed (GtkRecentManager* _sender, gpointer self) {
	recent_manager_gtk_items_changed (self);
}


static void recent_manager_gtk_real_start (DataProvider* base) {
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* _tmp2_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->recent_manager;
	g_signal_connect_object (_tmp0_, "changed", (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self, 0);
	_tmp1_ = recent_manager_gtk_get_items (self);
	_tmp2_ = _tmp1_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp2_);
	_g_ptr_array_unref0 (_tmp2_);
}


static void recent_manager_gtk_real_stop (DataProvider* base) {
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_;
	guint _tmp1_ = 0U;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->recent_manager;
	g_signal_parse_name ("changed", GTK_TYPE_RECENT_MANAGER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _recent_manager_gtk_items_changed_gtk_recent_manager_changed, self);
}


static gboolean ___lambda0_ (RecentManagerGtk* self) {
	gboolean result = FALSE;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_;
	_tmp0_ = recent_manager_gtk_get_items (self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((DataProvider*) self, "items-available", _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	self->priv->idle_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ____lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda0_ (self);
	return result;
}


static void recent_manager_gtk_items_changed (RecentManagerGtk* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->idle_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda0__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->idle_id = _tmp1_;
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _gtk_recent_info_ref0 (gpointer self) {
	return self ? gtk_recent_info_ref (self) : NULL;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _gtk_recent_info_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}


static void _g_list_free__gtk_recent_info_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_recent_info_unref0_, NULL);
	g_list_free (self);
}


GPtrArray* recent_manager_gtk_get_items (RecentManagerGtk* self) {
	GPtrArray* result = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* events;
	gint64 _tmp1_ = 0LL;
	gint64 signal_time;
	DataHub* _tmp2_;
	DataHub* _tmp3_;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gchar** ignored_actors;
	gint ignored_actors_length1;
	gint _ignored_actors_size_;
	GtkRecentManager* _tmp6_;
	GList* _tmp7_ = NULL;
	gint64 _tmp168_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = zeitgeist_timestamp_for_now ();
	signal_time = _tmp1_;
	_tmp2_ = data_provider_get_datahub ((DataProvider*) self);
	_tmp3_ = _tmp2_;
	_tmp5_ = data_hub_get_data_source_actors (_tmp3_, TRUE, &_tmp4_);
	ignored_actors = _tmp5_;
	ignored_actors_length1 = _tmp4_;
	_ignored_actors_size_ = ignored_actors_length1;
	_tmp6_ = self->priv->recent_manager;
	_tmp7_ = gtk_recent_manager_get_items (_tmp6_);
	{
		GList* ri_collection = NULL;
		GList* ri_it = NULL;
		ri_collection = _tmp7_;
		for (ri_it = ri_collection; ri_it != NULL; ri_it = ri_it->next) {
			GtkRecentInfo* _tmp8_;
			GtkRecentInfo* ri = NULL;
			_tmp8_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) ri_it->data);
			ri = _tmp8_;
			{
				GtkRecentInfo* _tmp9_;
				const gchar* _tmp10_ = NULL;
				GFile* _tmp11_ = NULL;
				GFile* file_obj;
				GFile* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* uri;
				gboolean _tmp14_ = FALSE;
				GtkRecentInfo* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp19_;
				gboolean _tmp20_ = FALSE;
				GtkRecentInfo* _tmp21_;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp25_;
				GtkRecentInfo* _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* last_app;
				const gchar* exec_str = NULL;
				guint count = 0U;
				gulong time_ = 0UL;
				GtkRecentInfo* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_ = NULL;
				guint _tmp34_ = 0U;
				gulong _tmp35_ = 0UL;
				gboolean _tmp36_ = FALSE;
				gboolean registered;
				gboolean _tmp37_;
				const gchar* _tmp40_;
				gchar** _tmp41_;
				gchar** _tmp42_ = NULL;
				gchar** exec;
				gint exec_length1;
				gint _exec_size_;
				gchar* desktop_file = NULL;
				gboolean _tmp43_ = FALSE;
				gchar** _tmp44_;
				gint _tmp44__length1;
				const gchar* _tmp45_;
				gboolean _tmp48_;
				const gchar* _tmp70_;
				const gchar* _tmp76_;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_;
				gchar* _tmp79_ = NULL;
				gchar* _tmp80_;
				gchar* actor;
				const gchar* _tmp81_;
				gchar** _tmp82_;
				gint _tmp82__length1;
				GFile* _tmp83_;
				GFile* _tmp84_ = NULL;
				GFile* parent_file;
				gchar* _tmp85_ = NULL;
				GFile* _tmp86_;
				const gchar* _tmp91_;
				gchar* _tmp92_;
				gchar* origin;
				const gchar* _tmp93_;
				GtkRecentInfo* _tmp94_;
				const gchar* _tmp95_ = NULL;
				const gchar* _tmp96_ = NULL;
				const gchar* _tmp97_;
				const gchar* _tmp98_ = NULL;
				GtkRecentInfo* _tmp99_;
				const gchar* _tmp100_ = NULL;
				const gchar* _tmp101_;
				GtkRecentInfo* _tmp102_;
				const gchar* _tmp103_ = NULL;
				ZeitgeistSubject* _tmp104_;
				ZeitgeistSubject* _tmp105_;
				ZeitgeistSubject* subject;
				ZeitgeistEvent* event = NULL;
				gint64 timestamp = 0LL;
				gboolean log_create;
				gboolean log_modify;
				gboolean log_access;
				GtkRecentInfo* _tmp106_;
				gulong _tmp107_ = 0UL;
				GtkRecentInfo* _tmp108_;
				gulong _tmp109_ = 0UL;
				GtkRecentInfo* _tmp110_;
				gulong _tmp111_ = 0UL;
				GtkRecentInfo* _tmp112_;
				gulong _tmp113_ = 0UL;
				gboolean _tmp114_;
				gboolean _tmp132_;
				gboolean _tmp150_;
				_tmp9_ = ri;
				_tmp10_ = gtk_recent_info_get_uri (_tmp9_);
				_tmp11_ = g_file_new_for_uri (_tmp10_);
				file_obj = _tmp11_;
				_tmp12_ = file_obj;
				_tmp13_ = g_file_get_uri (_tmp12_);
				uri = _tmp13_;
				_tmp15_ = ri;
				_tmp16_ = gtk_recent_info_get_private_hint (_tmp15_);
				if (_tmp16_) {
					_tmp14_ = TRUE;
				} else {
					const gchar* _tmp17_;
					gboolean _tmp18_ = FALSE;
					_tmp17_ = uri;
					_tmp18_ = g_str_has_prefix (_tmp17_, "file:///tmp/");
					_tmp14_ = _tmp18_;
				}
				_tmp19_ = _tmp14_;
				if (_tmp19_) {
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp21_ = ri;
				_tmp22_ = gtk_recent_info_is_local (_tmp21_);
				if (_tmp22_) {
					GtkRecentInfo* _tmp23_;
					gboolean _tmp24_ = FALSE;
					_tmp23_ = ri;
					_tmp24_ = gtk_recent_info_exists (_tmp23_);
					_tmp20_ = !_tmp24_;
				} else {
					_tmp20_ = FALSE;
				}
				_tmp25_ = _tmp20_;
				if (_tmp25_) {
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp26_ = ri;
				_tmp27_ = gtk_recent_info_last_application (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = string_strip (_tmp28_);
				_tmp30_ = _tmp29_;
				_g_free0 (_tmp28_);
				last_app = _tmp30_;
				_tmp31_ = ri;
				_tmp32_ = last_app;
				_tmp36_ = gtk_recent_info_get_application_info (_tmp31_, _tmp32_, &_tmp33_, &_tmp34_, &_tmp35_);
				exec_str = _tmp33_;
				count = _tmp34_;
				time_ = _tmp35_;
				registered = _tmp36_;
				_tmp37_ = registered;
				if (!_tmp37_) {
					const gchar* _tmp38_;
					GtkRecentInfo* _tmp39_;
					_tmp38_ = last_app;
					_tmp39_ = ri;
					g_warning ("recent-manager-provider.vala:107: %s was not registered in RecentInfo " \
"item %p", _tmp38_, _tmp39_);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp40_ = exec_str;
				_tmp42_ = _tmp41_ = g_strsplit_set (_tmp40_, " \t\n", 2);
				exec = _tmp42_;
				exec_length1 = _vala_array_length (_tmp41_);
				_exec_size_ = exec_length1;
				_tmp44_ = exec;
				_tmp44__length1 = exec_length1;
				_tmp45_ = _tmp44_[0];
				if (g_strcmp0 (_tmp45_, "soffice") == 0) {
					_tmp43_ = TRUE;
				} else {
					gchar** _tmp46_;
					gint _tmp46__length1;
					const gchar* _tmp47_;
					_tmp46_ = exec;
					_tmp46__length1 = exec_length1;
					_tmp47_ = _tmp46_[0];
					_tmp43_ = g_strcmp0 (_tmp47_, "ooffice") == 0;
				}
				_tmp48_ = _tmp43_;
				if (_tmp48_) {
					GtkRecentInfo* _tmp49_;
					const gchar* _tmp50_ = NULL;
					gchar* _tmp51_ = NULL;
					_tmp49_ = ri;
					_tmp50_ = gtk_recent_info_get_mime_type (_tmp49_);
					_tmp51_ = utils_get_ooo_desktop_file_for_mimetype (_tmp50_);
					_g_free0 (desktop_file);
					desktop_file = _tmp51_;
				} else {
					gchar** _tmp52_;
					gint _tmp52__length1;
					const gchar* _tmp53_;
					gchar* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
					const gchar* _tmp56_;
					gboolean _tmp60_;
					_tmp52_ = exec;
					_tmp52__length1 = exec_length1;
					_tmp53_ = _tmp52_[0];
					_tmp54_ = utils_find_desktop_file_for_app (_tmp53_, NULL);
					_g_free0 (desktop_file);
					desktop_file = _tmp54_;
					_tmp56_ = desktop_file;
					if (_tmp56_ == NULL) {
						gchar** _tmp57_;
						gint _tmp57__length1;
						const gchar* _tmp58_;
						gboolean _tmp59_ = FALSE;
						_tmp57_ = exec;
						_tmp57__length1 = exec_length1;
						_tmp58_ = _tmp57_[0];
						_tmp59_ = g_str_has_suffix (_tmp58_, "-bin");
						_tmp55_ = _tmp59_;
					} else {
						_tmp55_ = FALSE;
					}
					_tmp60_ = _tmp55_;
					if (_tmp60_) {
						gchar** _tmp61_;
						gint _tmp61__length1;
						const gchar* _tmp62_;
						gchar** _tmp63_;
						gint _tmp63__length1;
						const gchar* _tmp64_;
						gint _tmp65_;
						gint _tmp66_;
						gchar* _tmp67_ = NULL;
						gchar* _tmp68_;
						gchar* _tmp69_ = NULL;
						_tmp61_ = exec;
						_tmp61__length1 = exec_length1;
						_tmp62_ = _tmp61_[0];
						_tmp63_ = exec;
						_tmp63__length1 = exec_length1;
						_tmp64_ = _tmp63_[0];
						_tmp65_ = strlen (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = string_substring (_tmp62_, (glong) 0, (glong) (_tmp66_ - 4));
						_tmp68_ = _tmp67_;
						_tmp69_ = utils_find_desktop_file_for_app (_tmp68_, NULL);
						_g_free0 (desktop_file);
						desktop_file = _tmp69_;
						_g_free0 (_tmp68_);
					}
				}
				_tmp70_ = desktop_file;
				if (_tmp70_ == NULL) {
					const gchar* _tmp71_;
					gchar** _tmp72_;
					gint _tmp72__length1;
					const gchar* _tmp73_;
					GtkRecentInfo* _tmp74_;
					const gchar* _tmp75_ = NULL;
					_tmp71_ = uri;
					_tmp72_ = exec;
					_tmp72__length1 = exec_length1;
					_tmp73_ = _tmp72_[0];
					_tmp74_ = ri;
					_tmp75_ = gtk_recent_info_get_mime_type (_tmp74_);
					g_warning ("recent-manager-provider.vala:133: Desktop file for \"%s\" was not foun" \
"d, exec: %s, mime_type: %s", _tmp71_, _tmp73_, _tmp75_);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp76_ = desktop_file;
				_tmp77_ = g_path_get_basename (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = g_strdup_printf ("application://%s", _tmp78_);
				_tmp80_ = _tmp79_;
				_g_free0 (_tmp78_);
				actor = _tmp80_;
				_tmp81_ = actor;
				_tmp82_ = ignored_actors;
				_tmp82__length1 = ignored_actors_length1;
				if (_vala_string_array_contains (_tmp82_, _tmp82__length1, _tmp81_)) {
					_g_free0 (actor);
					_g_free0 (desktop_file);
					exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (last_app);
					_g_free0 (uri);
					_g_object_unref0 (file_obj);
					_gtk_recent_info_unref0 (ri);
					continue;
				}
				_tmp83_ = file_obj;
				_tmp84_ = g_file_get_parent (_tmp83_);
				parent_file = _tmp84_;
				_tmp86_ = parent_file;
				if (_tmp86_ != NULL) {
					GFile* _tmp87_;
					gchar* _tmp88_ = NULL;
					_tmp87_ = parent_file;
					_tmp88_ = g_file_get_uri (_tmp87_);
					_g_free0 (_tmp85_);
					_tmp85_ = _tmp88_;
				} else {
					const gchar* _tmp89_;
					gchar* _tmp90_ = NULL;
					_tmp89_ = uri;
					_tmp90_ = g_path_get_dirname (_tmp89_);
					_g_free0 (_tmp85_);
					_tmp85_ = _tmp90_;
				}
				_tmp91_ = _tmp85_;
				_tmp92_ = g_strdup (_tmp91_);
				origin = _tmp92_;
				_tmp93_ = uri;
				_tmp94_ = ri;
				_tmp95_ = gtk_recent_info_get_mime_type (_tmp94_);
				_tmp96_ = zeitgeist_interpretation_for_mimetype (_tmp95_);
				_tmp97_ = uri;
				_tmp98_ = zeitgeist_manifestation_for_uri (_tmp97_);
				_tmp99_ = ri;
				_tmp100_ = gtk_recent_info_get_mime_type (_tmp99_);
				_tmp101_ = origin;
				_tmp102_ = ri;
				_tmp103_ = gtk_recent_info_get_display_name (_tmp102_);
				_tmp104_ = zeitgeist_subject_new_full (_tmp93_, _tmp96_, _tmp98_, _tmp100_, _tmp101_, _tmp103_, "");
				_tmp105_ = g_object_ref_sink (_tmp104_);
				subject = _tmp105_;
				log_create = TRUE;
				log_modify = TRUE;
				log_access = TRUE;
				_tmp106_ = ri;
				_tmp107_ = gtk_recent_info_get_added (_tmp106_);
				_tmp108_ = ri;
				_tmp109_ = gtk_recent_info_get_modified (_tmp108_);
				if (_tmp107_ == _tmp109_) {
					log_modify = FALSE;
				}
				_tmp110_ = ri;
				_tmp111_ = gtk_recent_info_get_modified (_tmp110_);
				_tmp112_ = ri;
				_tmp113_ = gtk_recent_info_get_visited (_tmp112_);
				if (_tmp111_ == _tmp113_) {
					log_access = FALSE;
				}
				_tmp114_ = log_create;
				if (_tmp114_) {
					const gchar* _tmp115_;
					ZeitgeistSubject* _tmp116_;
					ZeitgeistEvent* _tmp117_;
					ZeitgeistEvent* _tmp118_;
					GtkRecentInfo* _tmp119_;
					gulong _tmp120_ = 0UL;
					gint64 _tmp121_;
					ZeitgeistEvent* _tmp122_;
					gint64 _tmp123_;
					gboolean _tmp124_ = FALSE;
					gint64 _tmp125_;
					gint64 _tmp126_;
					gint64 _tmp127_;
					gboolean _tmp129_;
					_tmp115_ = actor;
					_tmp116_ = subject;
					_tmp117_ = zeitgeist_event_new_full (ZEITGEIST_ZG_CREATE_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp115_, _tmp116_, NULL, NULL);
					_tmp118_ = g_object_ref_sink (_tmp117_);
					_g_object_unref0 (event);
					event = _tmp118_;
					_tmp119_ = ri;
					_tmp120_ = gtk_recent_info_get_added (_tmp119_);
					timestamp = (gint64) _tmp120_;
					_tmp121_ = timestamp;
					timestamp = _tmp121_ * 1000;
					_tmp122_ = event;
					_tmp123_ = timestamp;
					zeitgeist_event_set_timestamp (_tmp122_, _tmp123_);
					_tmp125_ = timestamp;
					_tmp126_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp127_ = _tmp126_;
					if (_tmp125_ > _tmp127_) {
						gint64 _tmp128_;
						_tmp128_ = timestamp;
						_tmp124_ = _tmp128_ >= ((gint64) 0);
					} else {
						_tmp124_ = FALSE;
					}
					_tmp129_ = _tmp124_;
					if (_tmp129_) {
						GPtrArray* _tmp130_;
						ZeitgeistEvent* _tmp131_;
						_tmp130_ = events;
						_tmp131_ = event;
						event = NULL;
						g_ptr_array_add (_tmp130_, _tmp131_);
					}
				}
				_tmp132_ = log_modify;
				if (_tmp132_) {
					const gchar* _tmp133_;
					ZeitgeistSubject* _tmp134_;
					ZeitgeistEvent* _tmp135_;
					ZeitgeistEvent* _tmp136_;
					GtkRecentInfo* _tmp137_;
					gulong _tmp138_ = 0UL;
					gint64 _tmp139_;
					ZeitgeistEvent* _tmp140_;
					gint64 _tmp141_;
					gboolean _tmp142_ = FALSE;
					gint64 _tmp143_;
					gint64 _tmp144_;
					gint64 _tmp145_;
					gboolean _tmp147_;
					_tmp133_ = actor;
					_tmp134_ = subject;
					_tmp135_ = zeitgeist_event_new_full (ZEITGEIST_ZG_MODIFY_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp133_, _tmp134_, NULL, NULL);
					_tmp136_ = g_object_ref_sink (_tmp135_);
					_g_object_unref0 (event);
					event = _tmp136_;
					_tmp137_ = ri;
					_tmp138_ = gtk_recent_info_get_modified (_tmp137_);
					timestamp = (gint64) _tmp138_;
					_tmp139_ = timestamp;
					timestamp = _tmp139_ * 1000;
					_tmp140_ = event;
					_tmp141_ = timestamp;
					zeitgeist_event_set_timestamp (_tmp140_, _tmp141_);
					_tmp143_ = timestamp;
					_tmp144_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp145_ = _tmp144_;
					if (_tmp143_ > _tmp145_) {
						gint64 _tmp146_;
						_tmp146_ = timestamp;
						_tmp142_ = _tmp146_ >= ((gint64) 0);
					} else {
						_tmp142_ = FALSE;
					}
					_tmp147_ = _tmp142_;
					if (_tmp147_) {
						GPtrArray* _tmp148_;
						ZeitgeistEvent* _tmp149_;
						_tmp148_ = events;
						_tmp149_ = event;
						event = NULL;
						g_ptr_array_add (_tmp148_, _tmp149_);
					}
				}
				_tmp150_ = log_access;
				if (_tmp150_) {
					const gchar* _tmp151_;
					ZeitgeistSubject* _tmp152_;
					ZeitgeistEvent* _tmp153_;
					ZeitgeistEvent* _tmp154_;
					GtkRecentInfo* _tmp155_;
					gulong _tmp156_ = 0UL;
					gint64 _tmp157_;
					ZeitgeistEvent* _tmp158_;
					gint64 _tmp159_;
					gboolean _tmp160_ = FALSE;
					gint64 _tmp161_;
					gint64 _tmp162_;
					gint64 _tmp163_;
					gboolean _tmp165_;
					_tmp151_ = actor;
					_tmp152_ = subject;
					_tmp153_ = zeitgeist_event_new_full (ZEITGEIST_ZG_ACCESS_EVENT, ZEITGEIST_ZG_USER_ACTIVITY, _tmp151_, _tmp152_, NULL, NULL);
					_tmp154_ = g_object_ref_sink (_tmp153_);
					_g_object_unref0 (event);
					event = _tmp154_;
					_tmp155_ = ri;
					_tmp156_ = gtk_recent_info_get_visited (_tmp155_);
					timestamp = (gint64) _tmp156_;
					_tmp157_ = timestamp;
					timestamp = _tmp157_ * 1000;
					_tmp158_ = event;
					_tmp159_ = timestamp;
					zeitgeist_event_set_timestamp (_tmp158_, _tmp159_);
					_tmp161_ = timestamp;
					_tmp162_ = data_provider_get_last_timestamp ((DataProvider*) self);
					_tmp163_ = _tmp162_;
					if (_tmp161_ > _tmp163_) {
						gint64 _tmp164_;
						_tmp164_ = timestamp;
						_tmp160_ = _tmp164_ >= ((gint64) 0);
					} else {
						_tmp160_ = FALSE;
					}
					_tmp165_ = _tmp160_;
					if (_tmp165_) {
						GPtrArray* _tmp166_;
						ZeitgeistEvent* _tmp167_;
						_tmp166_ = events;
						_tmp167_ = event;
						event = NULL;
						g_ptr_array_add (_tmp166_, _tmp167_);
					}
				}
				_g_object_unref0 (event);
				_g_object_unref0 (subject);
				_g_free0 (origin);
				_g_free0 (_tmp85_);
				_g_object_unref0 (parent_file);
				_g_free0 (actor);
				_g_free0 (desktop_file);
				exec = (_vala_array_free (exec, exec_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (last_app);
				_g_free0 (uri);
				_g_object_unref0 (file_obj);
				_gtk_recent_info_unref0 (ri);
			}
		}
		__g_list_free__gtk_recent_info_unref0_0 (ri_collection);
	}
	_tmp168_ = signal_time;
	data_provider_set_last_timestamp ((DataProvider*) self, _tmp168_);
	result = events;
	ignored_actors = (_vala_array_free (ignored_actors, ignored_actors_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static const gchar* recent_manager_gtk_real_get_unique_id (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_unique_id;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_unique_id (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_unique_id);
	self->priv->_unique_id = _tmp1_;
	g_object_notify ((GObject *) self, "unique-id");
}


static const gchar* recent_manager_gtk_real_get_name (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_name (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


static const gchar* recent_manager_gtk_real_get_description (DataProvider* base) {
	const gchar* result;
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_description (DataProvider* base, const gchar* value) {
	RecentManagerGtk* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_description);
	self->priv->_description = _tmp1_;
	g_object_notify ((GObject *) self, "description");
}


static DataHub* recent_manager_gtk_real_get_datahub (DataProvider* base) {
	DataHub* result;
	RecentManagerGtk* self;
	DataHub* _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_datahub;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void recent_manager_gtk_real_set_datahub (DataProvider* base, DataHub* value) {
	RecentManagerGtk* self;
	DataHub* _tmp0_;
	DataHub* _tmp1_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_datahub);
	self->priv->_datahub = _tmp1_;
	g_object_notify ((GObject *) self, "datahub");
}


static gboolean recent_manager_gtk_real_get_enabled (DataProvider* base) {
	gboolean result;
	RecentManagerGtk* self;
	gboolean _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_enabled;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_enabled (DataProvider* base, gboolean value) {
	RecentManagerGtk* self;
	gboolean _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	self->priv->_enabled = _tmp0_;
	g_object_notify ((GObject *) self, "enabled");
}


static gboolean recent_manager_gtk_real_get_register (DataProvider* base) {
	gboolean result;
	RecentManagerGtk* self;
	gboolean _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = self->priv->_register;
	result = _tmp0_;
	return result;
}


static void recent_manager_gtk_real_set_register (DataProvider* base, gboolean value) {
	RecentManagerGtk* self;
	gboolean _tmp0_;
	self = (RecentManagerGtk*) base;
	_tmp0_ = value;
	self->priv->_register = _tmp0_;
	g_object_notify ((GObject *) self, "register");
}


static GObject * recent_manager_gtk_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	RecentManagerGtk * self;
	GtkRecentManager* _tmp0_ = NULL;
	GtkRecentManager* _tmp1_;
	parent_class = G_OBJECT_CLASS (recent_manager_gtk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = RECENT_MANAGER_GTK (obj);
	_tmp0_ = gtk_recent_manager_get_default ();
	self->priv->recent_manager = _tmp0_;
	_tmp1_ = self->priv->recent_manager;
	gtk_recent_manager_set_limit (_tmp1_, -1);
	return obj;
}


static void recent_manager_gtk_class_init (RecentManagerGtkClass * klass) {
	recent_manager_gtk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RecentManagerGtkPrivate));
	DATA_PROVIDER_CLASS (klass)->start = recent_manager_gtk_real_start;
	DATA_PROVIDER_CLASS (klass)->stop = recent_manager_gtk_real_stop;
	DATA_PROVIDER_CLASS (klass)->get_unique_id = recent_manager_gtk_real_get_unique_id;
	DATA_PROVIDER_CLASS (klass)->set_unique_id = recent_manager_gtk_real_set_unique_id;
	DATA_PROVIDER_CLASS (klass)->get_name = recent_manager_gtk_real_get_name;
	DATA_PROVIDER_CLASS (klass)->set_name = recent_manager_gtk_real_set_name;
	DATA_PROVIDER_CLASS (klass)->get_description = recent_manager_gtk_real_get_description;
	DATA_PROVIDER_CLASS (klass)->set_description = recent_manager_gtk_real_set_description;
	DATA_PROVIDER_CLASS (klass)->get_datahub = recent_manager_gtk_real_get_datahub;
	DATA_PROVIDER_CLASS (klass)->set_datahub = recent_manager_gtk_real_set_datahub;
	DATA_PROVIDER_CLASS (klass)->get_enabled = recent_manager_gtk_real_get_enabled;
	DATA_PROVIDER_CLASS (klass)->set_enabled = recent_manager_gtk_real_set_enabled;
	DATA_PROVIDER_CLASS (klass)->get_register = recent_manager_gtk_real_get_register;
	DATA_PROVIDER_CLASS (klass)->set_register = recent_manager_gtk_real_set_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_recent_manager_gtk_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_recent_manager_gtk_set_property;
	G_OBJECT_CLASS (klass)->constructor = recent_manager_gtk_constructor;
	G_OBJECT_CLASS (klass)->finalize = recent_manager_gtk_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_UNIQUE_ID, g_param_spec_string ("unique-id", "unique-id", "unique-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_DATAHUB, g_param_spec_object ("datahub", "datahub", "datahub", TYPE_DATA_HUB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_ENABLED, g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RECENT_MANAGER_GTK_REGISTER, g_param_spec_boolean ("register", "register", "register", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void recent_manager_gtk_instance_init (RecentManagerGtk * self) {
	self->priv = RECENT_MANAGER_GTK_GET_PRIVATE (self);
	self->priv->_enabled = TRUE;
	self->priv->_register = TRUE;
	self->priv->idle_id = (guint) 0;
}


static void recent_manager_gtk_finalize (GObject* obj) {
	RecentManagerGtk * self;
	self = RECENT_MANAGER_GTK (obj);
	_g_free0 (self->priv->_unique_id);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_datahub);
	G_OBJECT_CLASS (recent_manager_gtk_parent_class)->finalize (obj);
}


GType recent_manager_gtk_get_type (void) {
	static volatile gsize recent_manager_gtk_type_id__volatile = 0;
	if (g_once_init_enter (&recent_manager_gtk_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RecentManagerGtkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) recent_manager_gtk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RecentManagerGtk), 0, (GInstanceInitFunc) recent_manager_gtk_instance_init, NULL };
		GType recent_manager_gtk_type_id;
		recent_manager_gtk_type_id = g_type_register_static (TYPE_DATA_PROVIDER, "RecentManagerGtk", &g_define_type_info, 0);
		g_once_init_leave (&recent_manager_gtk_type_id__volatile, recent_manager_gtk_type_id);
	}
	return recent_manager_gtk_type_id__volatile;
}


static void _vala_recent_manager_gtk_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RecentManagerGtk * self;
	self = RECENT_MANAGER_GTK (object);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID:
		g_value_set_string (value, data_provider_get_unique_id ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_NAME:
		g_value_set_string (value, data_provider_get_name ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION:
		g_value_set_string (value, data_provider_get_description ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_DATAHUB:
		g_value_set_object (value, data_provider_get_datahub ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_ENABLED:
		g_value_set_boolean (value, data_provider_get_enabled ((DataProvider*) self));
		break;
		case RECENT_MANAGER_GTK_REGISTER:
		g_value_set_boolean (value, data_provider_get_register ((DataProvider*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_recent_manager_gtk_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RecentManagerGtk * self;
	self = RECENT_MANAGER_GTK (object);
	switch (property_id) {
		case RECENT_MANAGER_GTK_UNIQUE_ID:
		data_provider_set_unique_id ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_NAME:
		data_provider_set_name ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DESCRIPTION:
		data_provider_set_description ((DataProvider*) self, g_value_get_string (value));
		break;
		case RECENT_MANAGER_GTK_DATAHUB:
		data_provider_set_datahub ((DataProvider*) self, g_value_get_object (value));
		break;
		case RECENT_MANAGER_GTK_ENABLED:
		data_provider_set_enabled ((DataProvider*) self, g_value_get_boolean (value));
		break;
		case RECENT_MANAGER_GTK_REGISTER:
		data_provider_set_register ((DataProvider*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



